<?php
include('header.php');
include('config/koneksi.php');

$isLoggedIn = false;
$idMember = '';

if (isset($_SESSION['login']) && $_SESSION['login'] == 1) {
    $isLoggedIn = true;
    $idMember = $_SESSION['UserID'] ?? '';
} elseif (isset($_COOKIE['fe_remember_email'])) {
    $isLoggedIn = true;
    $_SESSION['login'] = 1;
    $_SESSION['Email'] = $_COOKIE['fe_remember_email'];
    $_SESSION['FullName'] = $_COOKIE['fe_remember_fullname'] ?? 'Profile';
    $idMember = $_SESSION['UserID'] ?? '';
}

if (!$isLoggedIn || empty($idMember)) {
    header("Location: login.php");
    exit;
}
$sql = "SELECT 
    o.order_id,
    o.member_id,
    o.total_harga,
    o.status,
    o.tanggal_order,
    mo.membership_id,
    mo.harga AS harga_membership,
    p.package_name,
    p.duration,
    p.price AS harga_paket
FROM orders o
LEFT JOIN membersip_order mo ON o.order_id = mo.order_id
LEFT JOIN membership_packages p ON mo.membership_id = p.package_id
WHERE o.member_id = ?
ORDER BY o.tanggal_order DESC;";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $idMember);
$stmt->execute();
$result = $stmt->get_result();

$transactions = [];
while ($row = $result->fetch_assoc()) {
    $transactions[] = $row;
}

$stmt->close();
?>

<link rel="stylesheet" href="css/membership.css">

<section class="hero-section" style="background: linear-gradient(to right, #080808aa, #242124aa), url('img/bgMember.jpg') center/cover no-repeat;">
    <div class="container text-center">
        <h1 class="display-4 fw-bold mb-3">RIWAYAT TRANSAKSI ANDA</h1>
        <p class="lead mb-4">Lihat daftar transaksi membership Anda</p>
    </div>
</section>

<div class="container my-5">
    <?php if (count($transactions) > 0): ?>
        <div class="row">
            <?php foreach ($transactions as $trx): ?>
                <div class="col-md-4 mb-4">
                    <?php if ($trx['package_name']): ?>
                        
                        <div class="card shadow h-100 border-primary">
                            <div class="card-header bg-primary text-white">
                                <strong>Membership</strong>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title mb-2"><?= htmlspecialchars($trx['package_name']) ?></h5>
                                <p class="mb-1"><strong>Durasi:</strong> <?= htmlspecialchars($trx['duration']) ?></p>
                                <p class="mb-1"><strong>Harga Paket:</strong> Rp <?= number_format($trx['harga_paket'], 0, ',', '.') ?></p>
                                <hr>
                                <p class="mb-1"><strong>Order ID:</strong> <?= $trx['order_id'] ?></p>
                                <p class="mb-1"><strong>Total Bayar:</strong> Rp <?= number_format($trx['total_harga'], 0, ',', '.') ?></p>
                                <p class="mb-1"><strong>Status:</strong> 
                                    <span class="badge bg-<?= ($trx['status'] == 'Dibayar' || $trx['status'] == 'Selesai') ? 'success' : 'warning' ?>">
                                        <?= ucfirst($trx['status']) ?>
                                    </span>
                                </p>
                                <p class="text-muted mt-2" style="font-size: 0.9rem;">Tanggal: <?= date('d M Y H:i', strtotime($trx['tanggal_order'])) ?></p>
                            </div>
                        </div>

                    <?php else: ?>
                 
                        <div class="card shadow h-100 border-success">
                            <div class="card-header bg-success text-white">
                                <strong>Produk</strong>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title mb-2">Pembelian Produk</h5>
                                <p class="mb-1"><strong>Order ID:</strong> <?= $trx['order_id'] ?></p>
                                <p class="mb-1"><strong>Total Bayar:</strong> Rp <?= number_format($trx['total_harga'], 0, ',', '.') ?></p>
                                <p class="mb-1"><strong>Status:</strong> 
                                    <span class="badge bg-<?= ($trx['status'] == 'Dibayar' || $trx['status'] == 'Selesai') ? 'success' : 'warning' ?>">
                                        <?= ucfirst($trx['status']) ?>
                                    </span>
                                </p>
                                <p class="text-muted mt-2" style="font-size: 0.9rem;">Tanggal: <?= date('d M Y H:i', strtotime($trx['tanggal_order'])) ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="alert alert-info text-center">
            Belum ada transaksi yang Anda lakukan.
        </div>
    <?php endif; ?>
</div>



<?php include('footer.php'); ?>
