<?php
include('config/sesiRegister.php');
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Register LEON GYM</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/login.css">
</head>
<body>

<div class="login-box">
    <h2>Sign Up</h2>
    <p>Create your account</p>

    <?php if (!empty($error)): ?>
        <div class="error"><?php echo htmlspecialchars($error); ?></div>
    <?php elseif (!empty($success)): ?>
        <div class="success"><?php echo htmlspecialchars($success); ?></div>
    <?php endif; ?>

    <?php if (!empty($errors['all'])): ?>
    <div class="error"><?php echo htmlspecialchars($errors['all']); ?></div>
    <?php endif; ?>

    <form method="post" action="">
        <input type="text" name="fullname" placeholder="Nama Panjang" required pattern="^[^0-9]+$" title="Nama tidak boleh mengandung angka" value="<?php echo isset($_POST['fullname']) ? htmlspecialchars($_POST['fullname']) : ''; ?>">

        <select name="gender" required>
            <option value="">Pilih Jenis Kelamin</option>
            <option value="Laki-laki" <?php if (isset($_POST['gender']) && $_POST['gender'] == 'Laki-laki') echo 'selected'; ?>>Laki-laki</option>
            <option value="Perempuan" <?php if (isset($_POST['gender']) && $_POST['gender'] == 'Perempuan') echo 'selected'; ?>>Perempuan</option>
        </select>

        <input type="date" name="birthdate" required value="<?php echo isset($_POST['birthdate']) ? htmlspecialchars($_POST['birthdate']) : ''; ?>">

        <input type="email" name="email" placeholder="Email" required value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>">
        <input type="password" name="password" placeholder="Password" required minlength="8">
        <input type="password" name="confirm" placeholder="Konfirmasi Password" required minlength="8">

        <button type="submit">Register</button>
    </form>

    <div class="signup">Sudah punya akun? <a href="login.php">Login</a></div>
</div>

</body>
</html>
