<?php
include('header.php');
include('config/koneksi.php');

$isLoggedIn = false;
$idMember = '';
$memberSub = null;

if (isset($_SESSION['login']) && $_SESSION['login'] == 1) {
    $isLoggedIn = true;
    $idMember = $_SESSION['UserID'] ?? '';
} elseif (isset($_COOKIE['fe_remember_email'])) {
    $isLoggedIn = true;
    $_SESSION['login'] = 1;
    $_SESSION['Email'] = $_COOKIE['fe_remember_email'];
    $_SESSION['FullName'] = $_COOKIE['fe_remember_fullname'] ?? 'Profile';
    $idMember = $_SESSION['UserID'] ?? '';
}

if ($isLoggedIn && !empty($idMember)) {
    $sqlmemb = "SELECT * FROM member_subscriptions WHERE member_id = ?";
    $stmt = $conn->prepare($sqlmemb);
    $stmt->bind_param("i", $idMember);
    $stmt->execute();
    $resultSub = $stmt->get_result();
    $memberSub = $resultSub->fetch_assoc();
    $stmt->close();
}

$query = "SELECT * FROM membership_packages";
$result = mysqli_query($conn, $query);

$plans = [];
while ($row = mysqli_fetch_assoc($result)) {
    $full_duration = $row['duration'];
    $price = "Rp " . number_format($row['price'], 0, ',', '.') . " | " . $full_duration;
    $features = explode("\n", $row['description']);

    $plans[] = [
        'id' => $row['package_id'],
        'title' => $row['package_name'],
        'price' => $price,
        'raw_price' => $row['price'],
        'duration' => $row['duration'],
        'features' => $features
    ];
}

mysqli_close($conn);
?>

<link rel="stylesheet" href="css/membership.css">

<section class="hero-section" style=" background: linear-gradient(to right, #080808aa, #242124aa), url('img/bgMember.jpg') center/cover no-repeat;">
    <div class="container text-center">
        <h1 class="display-4 fw-bold mb-3">PILIHAN PAKET MEMBERSHIP</h1>
        <p class="lead mb-4">Dapatkan akses terbaik sesuai kebutuhan</p>
    </div>
</section>

<div class="pricing-section">
    <?php foreach ($plans as $plan): ?>
        <div class="pricing-card">
            <div class="pricing-title"><?= htmlspecialchars($plan['title']) ?></div>
            <div class="pricing-price"><?= $plan['price'] ?></div>
            <div class="pricing-features">
                <?php foreach ($plan['features'] as $feature): ?>
                    <p><?= htmlspecialchars(trim($feature)) ?></p>
                <?php endforeach; ?>
            </div>

            <?php if ($memberSub && strtotime($memberSub['tanggal_berakhir']) > time()): ?>
                <button 
                    class="pricing-button" 
                    data-bs-toggle="modal" 
                    data-bs-target="#confirmModal<?= $plan['id'] ?>"
                >
                    Pilih Paket
                </button>
            <?php else: ?>
                <button 
                    class="pricing-button" 
                    data-bs-toggle="modal" 
                    data-bs-target="#paymentModal<?= $plan['id'] ?>"
                >
                    Pilih Paket
                </button>
            <?php endif; ?>
        </div>

        <div class="modal fade" id="paymentModal<?= $plan['id'] ?>" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Detail Pembayaran</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>
              <div class="modal-body">
                <p><strong>Paket:</strong> <?= htmlspecialchars($plan['title']) ?></p>
                <p><strong>Durasi:</strong> <?= htmlspecialchars($plan['duration']) ?></p>
                <p><strong>Harga:</strong> Rp <?= number_format($plan['raw_price'], 0, ',', '.') ?></p>
                <hr>
                <p>Silakan lanjut ke pembayaran atau konfirmasi ke admin.</p>
              </div>
              <div class="modal-footer">
                <a href="checkout.php?package_id=<?= $plan['id'] ?>" class="btn btn-primary">Lanjut Pembayaran</a>
              </div>
            </div>
          </div>
        </div>

        <?php if ($memberSub && strtotime($memberSub['tanggal_berakhir']) > time()): ?>
        <div class="modal fade" id="confirmModal<?= $plan['id'] ?>" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Membership Masih Aktif</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>
              <div class="modal-body">
                <p>Membership Anda saat ini masih aktif hingga <strong><?= date("d M Y", strtotime($memberSub['tanggal_berakhir'])) ?></strong>.</p>
                <p>Jika Anda membeli paket baru, membership sebelumnya akan <strong>hangus dan tidak dapat digunakan lagi</strong>.</p>
                <p>Apakah Anda yakin ingin melanjutkan pembelian?</p>
              </div>
              <div class="modal-footer">
                <a href="hapus_membership.php?package_id=<?= $plan['id'] ?>" class="btn btn-danger">Ya, Lanjutkan</a>
              </div>
            </div>
          </div>
        </div>
        <?php endif; ?>

    <?php endforeach; ?>
</div>

<?php include('footer.php'); ?>
