<?php
session_start();
require 'koneksi.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['foto_member'])) {

    $memberId = $_POST['member_id'];

    $foto = $_FILES['foto_member'];
    $allowedTypes = ['image/jpeg', 'image/png', 'image/jpg'];

    if ($foto['error'] === 0 && in_array($foto['type'], $allowedTypes)) {

        $imgData = file_get_contents($foto['tmp_name']);

        $sql = "UPDATE members SET foto_member = ? WHERE member_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $imgData, $memberId);

        if ($stmt->execute()) {
            header("Location: ../Profile.php?success=Foto berhasil diubah");
            exit();
        } else {
            echo "Gagal mengupload foto: " . $stmt->error;
        }
        
        $stmt->close();
    } else {
        echo "File tidak valid. Hanya JPG atau PNG yang diperbolehkan.";
    }

} else {
    echo "Permintaan tidak valid.";
}

$conn->close();
?>
