<?php
session_start();
include('koneksi.php');

$error = "";
$success = "";

function isValidFullname($name) {
    return preg_match("/^[a-zA-Z\s'-]+$/", $name);
}

$memberId = $_POST['member_id'] ?? null;
$nama = trim($_POST['nama'] ?? '');
$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$jenisKelamin = $_POST['jenis_kelamin'] ?? '';
$tanggalLahir = $_POST['tanggal_lahir'] ?? '';
$noHp = $_POST['no_hp'] ?? '';
$alamat = $_POST['alamat'] ?? '';
$fotoMember = null;

if (!$memberId) {
    header("Location: ../Profile.php?error=" . urlencode("Member ID tidak valid."));
    exit();
}

if (!isValidFullname($nama)) {
    $error = "Nama tidak boleh mengandung angka atau karakter khusus.";
} elseif (!empty($password) && strlen($password) < 8) {
    $error = "Password harus minimal 8 karakter jika ingin diubah.";
} elseif (!preg_match('/^\d{1,15}$/', $noHp)) {
    $error = "Nomor HP harus berupa angka dan maksimal 15 digit.";
} else {
    $stmtCheck = $conn->prepare("SELECT member_id FROM members WHERE email = ? AND member_id != ?");
    $stmtCheck->bind_param("si", $email, $memberId);
    $stmtCheck->execute();
    $resultCheck = $stmtCheck->get_result();
    if ($resultCheck->num_rows > 0) {
        $error = "Email sudah digunakan pengguna lain.";
    }
    $stmtCheck->close();
}

if (empty($error)) {
    if (isset($_FILES['foto_member']) && $_FILES['foto_member']['size'] > 0) {
        $fotoMember = file_get_contents($_FILES['foto_member']['tmp_name']);
    }

    if (!empty($password)) {
        $hashedPassword = md5($password); 

        if ($fotoMember !== null) {
            $sql = "UPDATE members SET nama=?, email=?, password=?, jenis_kelamin=?, tanggal_lahir=?, no_hp=?, alamat=?, foto_member=? WHERE member_id=?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssssssssi", $nama, $email, $hashedPassword, $jenisKelamin, $tanggalLahir, $noHp, $alamat, $fotoMember, $memberId);
        } else {
            $sql = "UPDATE members SET nama=?, email=?, password=?, jenis_kelamin=?, tanggal_lahir=?, no_hp=?, alamat=? WHERE member_id=?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("sssssssi", $nama, $email, $hashedPassword, $jenisKelamin, $tanggalLahir, $noHp, $alamat, $memberId);
        }
    } else {
        if ($fotoMember !== null) {
            $sql = "UPDATE members SET nama=?, email=?, jenis_kelamin=?, tanggal_lahir=?, no_hp=?, alamat=?, foto_member=? WHERE member_id=?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("sssssssi", $nama, $email, $jenisKelamin, $tanggalLahir, $noHp, $alamat, $fotoMember, $memberId);
        } else {
            $sql = "UPDATE members SET nama=?, email=?, jenis_kelamin=?, tanggal_lahir=?, no_hp=?, alamat=? WHERE member_id=?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssssssi", $nama, $email, $jenisKelamin, $tanggalLahir, $noHp, $alamat, $memberId);
        }
    }

    if ($stmt->execute()) {
        $_SESSION['FullName'] = $nama;

        header("Location: ../Profile.php?success=" . urlencode("Profil berhasil diperbarui."));
        exit();
    } else {
        header("Location: ../Profile.php?error=" . urlencode("Gagal memperbarui profil: " . $stmt->error));
        exit();
    }

    $stmt->close();
    $conn->close();
} else {
    header("Location: ../Profile.php?error=" . urlencode($error));
    exit();
}
?>
