<?php
session_start();
include('koneksi.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email'])) {
    $email = trim($_POST['email']);

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        header("Location: ../lupaPassword.php?error=" . urlencode("Email tidak valid."));
        exit();
    }

    // Cek email user
    $stmt = $conn->prepare("SELECT member_id FROM members WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        $_SESSION['reset_member_id'] = $user['member_id'];
        header("Location: ../resetPassword.php");
        exit();
    } else {
        header("Location: ../lupaPassword.php?error=" . urlencode("Email tidak terdaftar."));
        exit();
    }
}
