<?php
include('header.php');
include('config/koneksi.php');
include('config/tampilProfil.php');

if (!isset($_SESSION['login']) || $_SESSION['login'] != 1) {
    header("Location: login.php");
    exit;
}

$product_id = intval($_GET['product_id'] ?? 0);
$quantity = intval($_GET['quantity'] ?? 1);

if ($product_id <= 0 || $quantity <= 0) {
    die("Data tidak valid.");
}

$query = "SELECT * FROM products WHERE product_id = $product_id";
$result = mysqli_query($conn, $query);

if (!$product = mysqli_fetch_assoc($result)) {
    die("Produk tidak ditemukan.");
}

if ($quantity > $product['stok']) {
    die("Jumlah pesanan melebihi stok tersedia.");
}

function generateOrderId() {
    $orderId = mt_rand(1, 9);
    for ($i = 0; $i < 9; $i++) {
        $orderId .= mt_rand(0, 9);
    }
    return $orderId;
}

$orderId = generateOrderId();
$ongkir = 15000;
$hargaProduk = $product['harga'] * $quantity;
$totalHarga = $hargaProduk + $ongkir;
?>

<link rel="stylesheet" href="css/membership.css">

<div class="container my-5">
    <h2 class="text-center mb-4">Checkout Produk</h2>
    <h6 class="text-center mb-4">Order ID: <?= $orderId ?></h6>

    <div class="row justify-content-center mb-4">
        <div class="col-md-6">
            <div class="card shadow-lg">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-box-seam me-2"></i> Detail Produk</h5>
                </div>
                <div class="card-body">
                    <div class="text-center mb-3">
                        <h4 class="fw-bold"><?= htmlspecialchars($product['nama_produk']) ?></h4>
                        <span class="badge bg-secondary"><?= $quantity ?> pcs</span>
                    </div>

                    <ul class="list-group list-group-flush mb-3">
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Harga Satuan:</span>
                            <strong>Rp <?= number_format($product['harga'], 0, ',', '.') ?></strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Ongkir:</span>
                            <strong id="ongkirDisplay">Rp <?= number_format($ongkir, 0, ',', '.') ?></strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between bg-light">
                            <span>Total Bayar:</span>
                            <strong id="totalBayarDisplay" class="text-success fs-5">Rp <?= number_format($totalHarga, 0, ',', '.') ?></strong>
                        </li>
                    </ul>

                    <div class="mt-3">
                        <h6 class="fw-bold">Deskripsi:</h6>
                        <p class="text-muted"><?= nl2br(htmlspecialchars($product['deskripsi'] ?? '-')) ?></p>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header"><h5 class="mb-0">Data Pengiriman</h5></div>
                <div class="card-body">
                    <form action="config/proses_pembayaran_produk.php" method="POST">
                        <input type="hidden" name="product_id" value="<?= $product['product_id'] ?>">
                        <input type="hidden" name="order_id" value="<?= $orderId ?>">
                        <input type="hidden" name="quantity" value="<?= $quantity ?>">
                        <input type="hidden" id="totalHargaInput" name="total_harga" value="<?= $totalHarga ?>">
                        

                        <div class="mb-3">
                            Nama: <br>
                            <?= htmlspecialchars($member['nama']) ?>
                        </div>
                        <div class="mb-3">
                            No Hp: <br>
                            <?= htmlspecialchars($member['no_hp']) ?>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Tipe Pengambilan</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="tipe_pengambilan" id="ambil_ditempat" value="Ambil di Tempat" checked>
                                <label class="form-check-label" for="ambil_ditempat">Ambil di Tempat (Gratis Ongkir)</label>
                            </div>
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="radio" name="tipe_pengambilan" id="delivery" value="Delivery">
                                <label class="form-check-label" for="delivery">Delivery (+ Ongkir Rp <?= number_format($ongkir, 0, ',', '.') ?>)</label>
                            </div>
                        </div>

                        <div class="mb-3" id="alamatSection" style="display: none;">
                            
                            <label for="alamat" class="form-label">Alamat Pengiriman</label>
                            <input type="hidden" name="member_id" value="<?= $member['member_id'] ?>">
                            <textarea class="form-control" id="alamat" name="alamat" rows="3"><?= htmlspecialchars($member['alamat']) ?></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Metode Pembayaran</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="payment_method" id="bayar_admin" value="Bayar Admin" required>
                                <label class="form-check-label" for="bayar_admin">Bayar ke Admin Langsung</label>
                            </div>
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="radio" name="payment_method" id="transfer_bank" value="Transfer Bank" required>
                                <label class="form-check-label" for="transfer_bank">Transfer Bank</label>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary w-100">Konfirmasi & Bayar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
const hargaProduk = <?= $hargaProduk ?>;
const ongkir = <?= $ongkir ?>;
const ongkirDisplay = document.getElementById('ongkirDisplay');
const totalBayarDisplay = document.getElementById('totalBayarDisplay');
const totalHargaInput = document.getElementById('totalHargaInput');
const alamatSection = document.getElementById('alamatSection');

document.getElementById('ambil_ditempat').addEventListener('change', updateHarga);
document.getElementById('delivery').addEventListener('change', updateHarga);

function updateHarga() {
    if (document.getElementById('delivery').checked) {
        ongkirDisplay.innerText = 'Rp ' + ongkir.toLocaleString('id-ID');
        totalBayarDisplay.innerText = 'Rp ' + (hargaProduk + ongkir).toLocaleString('id-ID');
        totalHargaInput.value = hargaProduk + ongkir;
        alamatSection.style.display = 'block';
    } else {
        ongkirDisplay.innerText = 'Rp 0';
        totalBayarDisplay.innerText = 'Rp ' + hargaProduk.toLocaleString('id-ID');
        totalHargaInput.value = hargaProduk;
        alamatSection.style.display = 'none';
    }
}
</script>

<?php include('footer.php'); ?>
