<?php
include('header.php');
include('config/koneksi.php');

if (!isset($_SESSION['login']) || $_SESSION['login'] != 1) {
    header("Location: login.php");
    exit;
}

if (isset($_GET['package_id'])) {
    $package_id = intval($_GET['package_id']);
} else {
    echo "Paket tidak ditemukan.";
    exit;
}

$query = "SELECT * FROM membership_packages WHERE package_id = $package_id";
$result = mysqli_query($conn, $query);

if (!$data = mysqli_fetch_assoc($result)) {
    echo "Paket tidak ditemukan.";
    exit;
}

function generateOrderId() {
    $orderId = mt_rand(1, 9);
    for ($i = 0; $i < 9; $i++) { 
        $orderId .= mt_rand(0, 9);
    }

    return $orderId;
}


$fullName = $_SESSION['FullName'] ?? 'Profile';
$email = $_SESSION['Email'] ?? '-';
$idMember = $_SESSION['UserID'] ?? '-';

$orderId = generateOrderId();
?>

<link rel="stylesheet" href="css/membership.css">

<div class="container my-5">
    <h2 class="text-center mb-4">Checkout Membership</h2>
    <h6 class="text-center mb-4">Order ID : <?= $orderId ?></h6>
    
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Profil Anda</h5>
                </div>
                <div class="card-body">
                    <p><strong>ID Member:</strong> <?= htmlspecialchars($idMember) ?></p>
                    <p><strong>Nama:</strong> <?= htmlspecialchars($fullName) ?></p>
                    <p><strong>Email:</strong> <?= htmlspecialchars($email) ?></p>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Metode Pembayaran</h5>
                </div>
                <div class="card-body">
                    <form action="config/proses_pembayaran.php" method="POST">
                        <input type="hidden" name="package_id" value="<?= htmlspecialchars($data['package_id']) ?>">
                        <input type="hidden" name="order_id" value="<?= htmlspecialchars($orderId) ?>">
                        
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="radio" name="payment_method" id="bayar_admin" value="Bayar Admin" required>
                            <label class="form-check-label" for="bayar_admin">
                                Bayar ke Admin Langsung
                            </label>
                        </div>
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="radio" name="payment_method" id="transfer_bank" value="Transfer Bank" required>
                            <label class="form-check-label" for="transfer_bank">
                                Transfer Bank
                            </label>
                        </div>

                        <button type="submit" class="btn btn-primary w-100">Konfirmasi Pembayaran</button>
                    </form>

                </div>
            </div>
        </div>

        <div class="col-md-5">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Detail Membership</h5>
                </div>
                <div class="card-body">
                    <h4><?= htmlspecialchars($data['package_name']) ?></h4>
                    <p><strong>Durasi:</strong> <?= htmlspecialchars($data['duration']) ?></p>
                    <p><strong>Harga:</strong> Rp <?= number_format($data['price'], 0, ',', '.') ?></p>
                    <hr>
                    <p><strong>Deskripsi:</strong></p>
                    <?php
                    $features = explode("\n", $data['description']);
                    foreach ($features as $feature):
                    ?>
                        <p><?= htmlspecialchars(trim($feature)) ?></p>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('footer.php'); ?>
