<?php
include('header.php');
include('config/tampilProfil.php');
?>

<div class="container mt-5">
  <div class="profile-container">
    <div class="profile-header text-center mb-4">
      <h2>Profil Member</h2>
    </div>

    <?php
    if (isset($_GET['error'])) {
        echo '<div class="alert alert-danger">'.htmlspecialchars($_GET['error']).'</div>';
    }
    if (isset($_GET['success'])) {
        echo '<div class="alert alert-success">'.htmlspecialchars($_GET['success']).'</div>';
    }
    ?>

    <?php if ($memberSub && isset($memberSub['tanggal_berakhir']) && strtotime($memberSub['tanggal_berakhir']) > time()): ?>
      <div class="membership-card active text-white text-center mb-4">
        <div class="status-header">
          <i class="fas fa-crown me-2"></i> Membership Aktif
        </div>
        <div class="status-detail mt-2">
          Paket: <strong><?= htmlspecialchars($memberPack['package_name'] ?? 'Premium') ?></strong><br>
          Aktif Sampai: <strong><?= date('d-m-Y', strtotime($memberSub['tanggal_berakhir'])) ?></strong>
        </div>
        <i class="fas fa-star membership-icon"></i>
      </div>
    <?php else: ?>
      <div class="membership-card inactive text-white text-center mb-4">
        <div class="status-header">
          <i class="fas fa-times-circle me-2"></i> Membership Tidak Aktif
        </div>
        <div class="status-detail mt-2">
          Anda belum memiliki membership aktif.<br>
          Silakan lakukan pembelian untuk mengakses fitur premium.
        </div>
        <i class="fas fa-ban membership-icon"></i>
      </div>
    <?php endif; ?>

    <div class="text-center mb-4 d-flex justify-content-center">
      <div class="profile-image-wrapper position-relative">
        <form action="config/uploadFoto.php" method="POST" enctype="multipart/form-data">
          <input type="hidden" name="member_id" value="<?= htmlspecialchars($member['member_id']) ?>">
          <img src="<?= !empty($member['foto_member']) ? 'data:image/jpeg;base64,' . base64_encode($member['foto_member']) : 'assets/img/default-profile.png' ?>"
               class="profile-image"
               id="previewImage"
               alt="Foto Profil"
               onclick="document.getElementById('foto_member').click();"
               style="cursor: pointer;">
          <div class="overlay-text" onclick="document.getElementById('foto_member').click();">
            Upload Gambar
          </div>
          <input type="file" id="foto_member" name="foto_member" class="d-none" accept="image/*" onchange="this.form.submit()">
        </form>
      </div>
    </div>

    <form action="config/updateProfile.php" method="POST">
      <input type="hidden" name="member_id" value="<?= htmlspecialchars($member['member_id']) ?>">

      <div class="row">
        <div class="col-md-6 mb-3">
          <label for="nama" class="form-label">Nama</label>
          <input type="text" class="form-control" id="nama" name="nama"
                 value="<?= htmlspecialchars($member['nama']) ?>" required
                 pattern="^[a-zA-Z\s'-]+$"
                 title="Nama hanya boleh berisi huruf, spasi, tanda hubung (-), dan apostrof (')">
        </div>
        <div class="col-md-6 mb-3">
          <label for="email" class="form-label">Email</label>
          <input type="email" class="form-control" id="email" name="email"
                 value="<?= htmlspecialchars($member['email']) ?>" required>
        </div>
      </div>

      <div class="mb-3">
        <label for="password" class="form-label">Password</label>
        <input type="password" class="form-control" id="password" name="password"
               placeholder="Kosongkan jika tidak ingin mengubah" minlength="8">
      </div>

      <div class="row">
        <div class="col-md-6 mb-3">
          <label for="jenis_kelamin" class="form-label">Jenis Kelamin</label>
          <select class="form-select" id="jenis_kelamin" name="jenis_kelamin" required>
            <option value="L" <?= $member['jenis_kelamin'] == 'L' ? 'selected' : '' ?>>Laki-laki</option>
            <option value="P" <?= $member['jenis_kelamin'] == 'P' ? 'selected' : '' ?>>Perempuan</option>
          </select>
        </div>
        <div class="col-md-6 mb-3">
          <label for="tanggal_lahir" class="form-label">Tanggal Lahir</label>
          <input type="date" class="form-control" id="tanggal_lahir" name="tanggal_lahir"
                 value="<?= htmlspecialchars($member['tanggal_lahir']) ?>">
        </div>
      </div>

      <div class="mb-3">
        <label for="no_hp" class="form-label">No HP</label>
        <input type="text" class="form-control" id="no_hp" name="no_hp"
               value="<?= htmlspecialchars($member['no_hp']) ?>">
      </div>

      <div class="mb-3">
        <label for="alamat" class="form-label">Alamat</label>
        <textarea class="form-control" id="alamat" name="alamat" rows="3"><?= htmlspecialchars($member['alamat']) ?></textarea>
      </div>

      <div class="text-end">
        <button type="submit" class="btn btn-primary px-4">Simpan Perubahan</button>
      </div>
    </form>
  </div>
</div>

<?php
include('footer.php');
?>
