<?php
include("koneksi.php");

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_id = $_POST['id'];
    $username = $_POST['username'];
    $nama_lengkap = $_POST['nama'];
    $role_id = $_POST['role'];
    $password = $_POST['password'];

    if (empty($user_id) || empty($username) || empty($nama_lengkap) || empty($role_id) || empty($password)) {
        die("Semua field harus diisi!");
    }

    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    $stmt = mysqli_prepare($conn, "INSERT INTO users (user_id, username, nama_lengkap, password, role_id) VALUES (?, ?, ?, ?, ?)");
    
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "ssssi", $user_id, $username, $nama_lengkap, $hashed_password, $role_id);
        $query = mysqli_stmt_execute($stmt);

        if ($query) {
            header("Location: ../Admin/admin.php");
            exit();
        } else {
            echo "Error: " . mysqli_error($cnn);
        }

        mysqli_stmt_close($stmt);
    } else {
        echo "Error preparing statement: " . mysqli_error($cnn);
    }

    mysqli_close($cnn);
} else {
    header("Location: ../Admin/admin.php");
    exit();
}