<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Paket Membership</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item active">List Paket Membership</li>
          </ol>
        </div>
      </div>
    </div>
  </section>

  <section class="content">
    <?php
    include '../config/koneksi.php';

    $query = "SELECT * FROM membership_packages";
    $result = mysqli_query($conn, $query);

    if (!$result) {
      echo "<div class='alert alert-danger'>Query Error: " . mysqli_error($conn) . "</div>";
    }
    ?>

    <div class="card">
    <div class="card-header">
              <h3 class="card-title"></h3>
             <button type="button" class="btn btn-success" data-toggle="modal" data-target="#modal-default">
              + Tambah Paket
      </div>
      <div class="card-body">
        <table id="paketTable" class="table table-bordered table-striped">
          <thead>
            <tr>
              <th>No</th>
              <th>Nama Paket</th>
              <th>Durasi (bulan)</th>
              <th>Harga</th>
              <th>Deskripsi</th>
              <th>Edit</th>
              <th>Hapus</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $no = 1;
            while ($row = mysqli_fetch_assoc($result)) {
            ?>
            <tr>
                <td><?php echo $no++; ?></td>
                <td><?php echo $row['package_name']; ?></td>
                <td><?php echo $row['duration']; ?></td>
                <td><?php echo number_format($row['price'], 2); ?></td>
                <td><?php echo $row['description']; ?></td>
                <td>
                  <button 
                      type="button" 
                      class="btn btn-primary" 
                      data-toggle="modal" 
                      data-target="#editMembership" 
                      data-id="<?= htmlspecialchars($row['package_id']) ?>" 
                      data-nama="<?= htmlspecialchars($row['package_name']) ?>"
                      data-durasi="<?= htmlspecialchars($row['duration']) ?>"
                      data-harga="<?= htmlspecialchars($row['price']) ?>"
                      data-deskripsi="<?= htmlspecialchars($row['description']) ?>"
                  >
                      Edit
                  </button>

                </td>

                <td>
                <form action="../config/hapuspaket.php" method="POST" onsubmit="return confirm('Yakin ingin menghapus paket ini?');">
                <input type="hidden" name="id_paket" value="<?php echo $row['package_id']; ?>">
                <button type="submit" class="btn btn-danger btn-sm">Hapus</button>
                </form>

                </td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    </div>
  </section>
</div>

<script>
  $(document).ready(function () {
    $('#paketTable').DataTable();
  });
</script>

<div class="modal fade" id="modal-default">
  <div class="modal-dialog">
    <div class="modal-content bg-dark text-white">
    
      <div class="modal-header border-0">
        <h4 class="modal-title">Tambah Paket</h4>
        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <div class="modal-body">
        <?php include('formpaket.php'); ?>
      </div>

    </div>
  </div>
</div>

<div class="modal fade" id="editMembership">
  <div class="modal-dialog">
    <div class="modal-content bg-dark text-white">
    
      <div class="modal-header border-0">
        <h4 class="modal-title">Tambah Paket</h4>
        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <div class="modal-body">
        <?php include('formeditpaket.php'); ?>
      </div>

    </div>
  </div>
</div>
 