<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Order</h1>
        </div>
      </div>
    </div>
  </section>

  <section class="content">
    <div class="container-fluid">
      <div class="card">

        <div class="card-body">
          <table id="tabelOrder" class="table table-bordered table-striped">
            <thead>
              <tr>
                <th>ID Order</th>
                <th>Nama Member</th>
                <th>Jenis Transaksi</th>
                <th>Total Harga</th>
                <th>Tanggal</th>
                <th>Metode Bayar</th>
                <th>Tipe Pengambilan</th>
                <th>Status</th>
                <th>Aksi</th>
                <th>Cek</th>
              </tr>
            </thead>
            <tbody>
              <?php
              include '../config/koneksi.php';
              $query = "SELECT o.order_id, m.nama AS nama_member, o.total_harga, o.tanggal_order, o.status, o.order_type, o.Metode_bayar, o.tipe_pengambilan, o.member_id
                        FROM orders o
                        JOIN members m ON o.member_id = m.member_id
                        ORDER BY 
                          CASE 
                            WHEN o.status = 'Dibayar' THEN 1
                            WHEN o.status = 'Pending' THEN 2
                            WHEN o.status = 'Diproses' THEN 3
                            WHEN o.status = 'Dikirim' THEN 4
                            WHEN o.status = 'Selesai' THEN 5
                            ELSE 6
                          END, o.tanggal_order DESC";
              $result = mysqli_query($conn, $query);
              while ($row = mysqli_fetch_assoc($result)) {
              ?>
<tr>
    <td><?= $row['order_id'] ?></td>
    <td><?= htmlspecialchars($row['nama_member']) ?></td>
    <td><?= $row['order_type'] ?></td>
    <td>Rp <?= number_format($row['total_harga'], 0, ',', '.') ?></td>
    <td><?= $row['tanggal_order'] ?></td>
    <td><?= $row['Metode_bayar'] ?></td>
    <td><?= !empty($row['tipe_pengambilan']) ? htmlspecialchars($row['tipe_pengambilan']) : '-' ?></td>
    <td><?= ucfirst($row['status']) ?></td>
    <td>
<?php 
$orderType = strtolower($row['order_type']);
$status = strtolower($row['status']);
$metode = strtolower($row['Metode_bayar']);
$tipe = strtolower($row['tipe_pengambilan']); 
$member_id = strtolower($row['member_id']);

if ($orderType == 'membership' && $status == 'dibayar' && $metode == 'transfer bank') { ?>

    <a href="../config/aktivasi.php?order_id=<?= $row['order_id'] ?>" class="btn btn-success btn-sm">Aktivasi</a>

<?php 

} elseif ($orderType == 'membership' && $status !== 'selesai' && $metode == 'bayar admin') { ?>            

    <a href="../config/aktivasi.php?order_id=<?= $row['order_id'] ?>" class="btn btn-success btn-sm">Aktivasi</a>

<?php 

} elseif ($orderType == 'produk' && $metode == 'bayar admin' && $status !== 'selesai' && $tipe == 'delivery') { ?>

    <form action="../config/update_status.php" method="POST">                    
        <input type="hidden" name="order_id" value="<?= $row['order_id'] ?>">
        <select name="status" class="form-control form-control-sm" onchange="this.form.submit()">
            <option value="">-- Ubah Status --</option>
            <option value="pending" <?= $status == 'pending' ? 'selected' : '' ?>>Pending</option>
            <option value="diproses" <?= $status == 'diproses' ? 'selected' : '' ?>>Diproses</option>
            <option value="dikirim" <?= $status == 'dikirim' ? 'selected' : '' ?>>Dikirim</option>
            <option value="selesai" <?= $status == 'selesai' ? 'selected' : '' ?>>Selesai</option>
        </select>
    </form>

<?php 

} elseif ($orderType == 'produk' && $metode == 'transfer bank' && $status !== 'selesai' && $tipe == 'delivery') { ?>

    <form action="../config/update_status.php" method="POST">                    
        <input type="hidden" name="order_id" value="<?= $row['order_id'] ?>">
        <select name="status" class="form-control form-control-sm" onchange="this.form.submit()">
            <option value="">-- Ubah Status --</option>
            <option value="diproses" <?= $status == 'diproses' ? 'selected' : '' ?>>Diproses</option>
            <option value="dikirim" <?= $status == 'dikirim' ? 'selected' : '' ?>>Dikirim</option>
            <option value="selesai" <?= $status == 'selesai' ? 'selected' : '' ?>>Selesai</option>
        </select>
    </form>

<?php 
} elseif ($orderType == 'produk' && ($metode == 'transfer bank' || $metode == 'bayar admin') && $status !== 'selesai' && $tipe == 'ambil di tempat') { ?>

    <form action="../config/update_status.php" method="POST">                    
        <input type="hidden" name="order_id" value="<?= $row['order_id'] ?>">
        <select name="status" class="form-control form-control-sm" onchange="this.form.submit()">
            <option value="">-- Ubah Status --</option>
            <option value="selesai" <?= $status == 'selesai' ? 'selected' : '' ?>>Selesai</option>
        </select>
    </form>            

<?php 

} elseif (($orderType == 'membership' || $orderType == 'produk') && $status == 'pending' && $metode == 'transfer bank') { ?>

    <span class="badge bg-danger">Belum Dibayar</span>

<?php 

} elseif (($orderType == 'membership' || $orderType == 'produk') && $status == 'selesai') { ?>

    <span>-</span>

<?php } ?>

    </td>
    
    <td>
      <a href="../Detail_produk/detail_prod.php?order_id=<?= $row['order_id'] ?>&total_harga=<?=$row['total_harga']?>&member_id=<?=$member_id?>"
            class="btn btn-success btn-sm">Detail</a>
          </td>
              </tr>
              <?php } ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>

<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(document).ready(function () {
    $('#tabelOrder').DataTable({
        paging: true,
        ordering: false,  
        language: {
            search: "Cari Order:",
            zeroRecords: "Data tidak ditemukan",
            info: "Menampilkan _START_ sampai _END_ dari _TOTAL_ entri",
            infoEmpty: "Menampilkan 0 sampai 0 dari 0 entri",
            infoFiltered: "(disaring dari _MAX_ total entri)",
            lengthMenu: "Tampilkan _MENU_ entri",
            paginate: {
                first: "Pertama",
                last: "Terakhir",
                next: "Selanjutnya",
                previous: "Sebelumnya"
            }
        }
    });
});
</script>